/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminItemInList;

public class VWAdminWflGroupDataObj {
    private String m_identifier = null;
    private VWParticipant[] m_participants = null;
    private VWAdminItemInList[] m_selectedObjects = null;

    public VWAdminWflGroupDataObj() {
    }

    public VWAdminWflGroupDataObj(VWDataField wflGroup) {
        try {
            this.m_identifier = wflGroup.getName();
            this.m_participants = (VWParticipant[])wflGroup.getValue();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public String toString() {
        return this.m_identifier;
    }

    protected String getName() {
        return this.m_identifier;
    }

    protected void setName(String name) {
        this.m_identifier = name;
    }

    protected VWParticipant[] getParticipants() {
        return this.m_participants;
    }

    protected void setParticipants(Object[] newParticipants) {
        if (newParticipants == null || newParticipants.length == 0) {
            this.m_participants = null;
        } else {
            this.m_participants = new VWParticipant[newParticipants.length];
            for (int i = 0; i < newParticipants.length; ++i) {
                VWAdminItemInList item = (VWAdminItemInList)newParticipants[i];
                this.m_participants[i] = new VWParticipant();
                this.m_participants[i].setParticipantName(item.getShortName());
            }
        }
        this.setSelectedObjects(newParticipants);
    }

    protected VWAdminItemInList[] getSelectedObjects() {
        return this.m_selectedObjects;
    }

    private void setSelectedObjects(Object[] newObjects) {
        try {
            if (newObjects == null || newObjects.length == 0) {
                this.m_selectedObjects = null;
            } else {
                this.m_selectedObjects = new VWAdminItemInList[newObjects.length];
                for (int i = 0; i < newObjects.length; ++i) {
                    VWAdminItemInList item = (VWAdminItemInList)newObjects[i];
                    this.m_selectedObjects[i] = new VWAdminItemInList(item.getVWParticipant(), item.isGrayedOut());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

